
** Table A.1

use "${dir3}INPS_temp_noPA.dta", clear
drop if year==2012

drop if p_b==.
drop if age<18 | age>65
g empl=n_paid_m>0
bysort id: egen sum_empl=sum(empl)
drop if sum_empl==0
drop sum_empl

replace p_wrk_i="PU" if p_wrk_i=="PS"
replace p_wrk_i="FO" if p_wrk_i=="FC"
rename p_wrk_i sigla_provincia103
merge m:1 sigla_provincia103 using "${dir3}codici_province_103.dta", keepusing(codice_provincia103 codice_regione) keep(master matched)
drop sigla_provincia103 _m
rename codice_provincia103 p_wrk_i 
rename codice_regione r_wrk_i
for any p r: g same_wX_as_birth=X_bth_i==X_wrk if X_bth!=. & X_wrk!=.

egen tag_id=tag(id)

gen other=occ_gr==1 if occ_gr!=.
gen appr=occ_gr==2 if occ_gr!=.
gen blue=occ_gr==3 if occ_gr!=.
gen clerk=occ_gr==4 if occ_gr!=.
gen white=occ_gr==5 if occ_gr!=.
gen exe=occ_gr==6 if occ_gr!=.

cap drop tmp
egen tmp=rsum(other appr blue clerk white exe)
for any other appr blue clerk white exe: replace X=0 if tmp>1
g missing_occ=1-tmp
drop tmp

label var appr "Apprentice"
label var blue "Blue collar"
label var clerk "Clerk"
label var white "White collar"
label var exe "Executive"
label var missing_occ "Missing"
replace blue=blue+appr

gen agr=f_sec2==1 if f_sec2!=.
gen ene=f_sec2==2 if f_sec2!=.
gen chem=f_sec2==3 if f_sec2!=.
gen mech=f_sec2==4 if f_sec2!=.
gen craft=f_sec2==5 if f_sec2!=.
gen constr=f_sec2==6 if f_sec2!=.
gen comm=f_sec2==7 if f_sec2!=.
gen trans=f_sec2==8 if f_sec2!=.
gen cred=f_sec2==9 if f_sec2!=.
gen serv=f_sec2==10 if f_sec2!=.

egen tmp=rsum( agr en chem mec cra cons com tran cred  serv)
for any agr en chem mec cra cons com tran cred  : replace X=0 if tmp>1
cap drop tmp
egen tmp=rsum( agr en chem mec cra cons com tran cred serv)
g missing_ind=1-tmp
drop tmp
g other_ind=craf
drop craft
label var agr "Agriculture"
label var en "Energy and utilities"
label var chem "Chemical"
label var mech "Mechanical"
label var cons "Construction"
label var com "Commerce"
label var tran "Transport"
label var cred "Banking"
label var serv "Services"
label var other_ind "Other industry"
label var missing_ind "Missing"

label var f_empl "Firm size"
cap drop missing_f_empl
g missing_f_empl=f_empl==.
label var missing_f_empl "Missing"

gen NO=r_bth_i==4 | r_bth_i==5 | r_bth_i==6 | r_bth_i==8 if r_bth_i!=.
replace NO=1 if r_bth_i==1 | r_bth_i==2 | r_bth_i==3 | r_bth_i==7 
gen CE=r_bth_i==9 | r_bth_i==10 | r_bth_i==11 | r_bth_i==12 if r_bth_i!=.
gen SO=r_bth_i==13 | r_bth_i==14 | r_bth_i==15 | r_bth_i==16 | r_bth_i==17 | r_bth_i==18 if r_bth_i!=.
replace SO=1 if r_bth_i==19 | r_bth_i==20 
g missing_r_birth=r_bth_i==.

label var NO "Area of birth: North"
label var CE "Area of birth: Center"
label var SO "Area of birth: South + Islands"

label var fem "Female"
label var age "Age"
label var empl "Employed"

label var n_paid_m "Months in work in the year"
label var tot_wg "Yearly earnings"
label var n_sp "Number of jobs in the year"

statsmat n_paid_m n_sp tot_wg fem age /*
*/ NO CE SO /*
*/ blu clerk white exe /*
*/ if n_paid_m!=0, stat(mean sd) listwise format(%20.3f) matrix(sample_workers)
outtable using "${dir5}sample_workers", replace nobox format( %20.3fc) label mat(sample_workers)

sum year if tot_wg!=0
sum year if tag_id==1
egen tag_id2=tag(id) if n_paid_m!=0
sum year if tag_id2==1


** Table A.2

use "${dir1}pol_temp.dta", clear
drop if p_year==0

label var p_fem "Female"
label var p_age "Age"
tab p_off_t, gen(p_off_t)
label var p_off_t1 "Head"
label var p_off_t2 "Executive"
label var p_off_t3 "Council"
tab p_inst, gen(p_inst)
label var p_inst1 "Municipal"
label var p_inst2 "Provincial"
label var p_inst3 "Regional"
label var p_inst4 "National"

egen tag_id=tag(p_id)

cap drop tmp
egen tmp=rsum(p_ele p_middle p_hs p_coll)
replace tmp=0 if tmp>1 
for any ele middle hs coll: replace p_X=0 if tmp>1
g p_missing_ed=1-tmp
drop tmp

egen tmp=rsum(p_dir p_law p_prof p_doc p_white p_blue p_jou p_sold p_other)
for any p_dir p_law p_prof p_doc p_white p_blue p_jou p_sold p_other : replace X=0 if tmp>1
g p_missing_occ=1-tmp
drop tmp

egen tmp=rsum(p_left p_cent p_right)
replace tmp=0 if tmp>1
for any cent left right: replace p_X=0 if tmp==0
g p_missing_party=1-tmp

g p_missing_elect=p_elect==.

for any c p r: g same_X_as_birth=p_X_bth_i==p_X_ele & p_X_e<.
 
egen min=min(year), by(p_id p_inst p_off_t)
egen max=max(year), by(p_id p_inst p_off_t)

g diff=max-min+1

label var p_ele "Primary"
label var p_mid "Junior High"
label var p_hs "High School"
label var p_coll "College"
label var p_missing_ed "Missing education"

label var p_blue "Blue collar"
label var p_w "White Collar"
label var p_sold "Military/Police"
label var p_doc "Physician"
label var p_prof "Professor/Teacher"
label var p_law "Lawyer/Judge"
label var p_dir "Manager"
label var p_other "Other occupation"
label var p_missing_occ "Missing occupation"

label var p_lef "Left"
label var p_right "Right"
label var p_cent "Center"
label var p_missing_party "Independent/missing party"
label var same_c "Munic. of election same as birth"
label var same_p "Province of election same as birth"
label var same_r "Region of election same as birth"

label var p_ten_c_t "Continued terms in same admin." 
label var p_cens "In office in 1985" 

label var p_elect "Elected"
label var p_missing_el "Missing elected"

gen NO=p_r_bth_i==4 | p_r_bth_i==5 | p_r_bth_i==6 | p_r_bth_i==8 if p_r_bth_i!=.
replace NO=1 if p_r_bth_i==1 | p_r_bth_i==2 | p_r_bth_i==3 | p_r_bth_i==7 
gen CE=p_r_bth_i==9 | p_r_bth_i==10 | p_r_bth_i==11 | p_r_bth_i==12 if p_r_bth_i!=.
gen SO=p_r_bth_i==13 | p_r_bth_i==14 | p_r_bth_i==15 | p_r_bth_i==16 | p_r_bth_i==17 | p_r_bth_i==18 if p_r_bth_i!=.
replace SO=1 if p_r_bth_i==19 | p_r_bth_i==20 
g missing_r_birth=p_r_bth_i==.

gen NO1=p_r_ele_i==4 | p_r_ele_i==5 | p_r_ele_i==6 | p_r_ele_i==8 if p_r_ele_i!=.
replace NO1=1 if p_r_ele_i==1 | p_r_ele_i==2 | p_r_ele_i==3 | p_r_ele_i==7 
gen CE1=p_r_ele_i==9 | p_r_ele_i==10 | p_r_ele_i==11 | p_r_ele_i==12 if p_r_ele_i!=.
gen SO1=p_r_ele_i==13 | p_r_ele_i==14 | p_r_ele_i==15 | p_r_ele_i==16 | p_r_ele_i==17 | p_r_ele_i==18 if p_r_ele_i!=.
replace SO1=1 if p_r_ele_i==19 | p_r_ele_i==20 
g missing_r_ele=p_r_ele_i==.

label var NO "Area of birth: North"
label var CE "Area of birth: Center"
label var SO "Area of birth: South + Islands"
label var missing_r_birth "Missing"

label var NO1 "Area of election: North"
label var CE1 "Area of election: Center"
label var SO1 "Area of election: South + Islands"
label var missing_r_ele "Missing"

gen p_ten_c_t_01=p_ten_c_t==1 if p_ten_c_t!=.
gen p_ten_c_t_12=p_ten_c_t==2 if p_ten_c_t!=.
gen p_ten_c_t_gt2=p_ten_c_t>2 if p_ten_c_t!=.

label var p_ten_c_t_01 "1 Term"
label var p_ten_c_t_12 "2 Terms"
label var p_ten_c_t_gt2 "$>$ 2 Terms"

statsmat  p_inst1 p_inst2 p_inst3 p_inst4 p_off_t3 p_off_t2 p_off_t1 p_ten_c_t_01 p_ten_c_t_12 p_ten_c_t_gt2 p_cens /*
*/  p_fem p_age p_ele p_middle p_hs p_coll  /*
*/ p_blue p_white p_dir p_sold p_doc p_prof p_law  p_other  /*
*/ NO CE SO  NO1 CE1 SO1 same* [aw=p_year], stat(mean sd) /*
*/ listwise format(%9.3f) matrix(sample_pol)
outtable using "${dir5}sample_pol", replace nobox format (%9.3f) label mat(sample_pol)

sum year
sum year if tag_id==1


** Table A.3

use if age<=65 using "${dir3}mergedCF1_noPA", replace

bysort id: egen tot=count(year)
keep if tot!=. & tot!=1
drop tot

bysort CF1 c_b year: egen pippo=count(year)
bysort CF1 c_b: egen fr_c_new=median(pippo)
drop pippo

gen n_pols_gt0=n_pols>0 if n_pols!=.
gen n_pols_1=n_pols>0 & n_pols<=1 if n_pols!=.
gen n_pols_2=n_pols>1 & n_pols<=2 if n_pols!=.
gen n_pols_gt2=n_pols>2 if n_pols!=.

egen tag_id=tag(id)

label var n_pols "Total politicians"
label var n_pols_gt0 "Total politician $>$ 0"
label var n_pols_1 "Total politicians = 1"
label var n_pols_2 "Total politicians = 2"
label var n_pols_gt2 "Total politicians $>$ 2"
label var n_pols_top "Head politicians"
label var n_pols_cou "Council politicians"
label var n_pols_c "Municipal politicians"
label var n_pols_p "Provincial politicians"
label var n_pols_r "Regional politicians"
label var n_pols_n "National politicians"

label var n_paid_m "Months in work in the year"
label var tot_wg "Yearly earnings"
label var empl "Employed"

statsmat n_paid_m empl tot_wg n_pols n_pols_gt0 n_pols_1 n_pols_2 n_pols_gt2 n_pols_c n_pols_p n_pols_r n_pols_n n_pols_cou n_pols_top, stat(mean sd) /*
*/ listwise format(%20.3f) matrix(sample_merge)
outtable using "${dir5}sample_merge_id", replace nobox format( %20.3fc) label mat(sample_merge)

sum year
sum year if tag_id==1
